/* ----------------------------------------------------START---------------------------------------------------- */
var gTableRowIndex = 0;
var gCurrentOperationTableRowIndex = 0;
var gCameraConnCnt = 0;
let gCameraConnectSet = new Set();
var gPTZTimerId = 0;
var gUsbLocation = "";
var gReloadPageCnt = 0;
var cam_json = {};

/* AI setting */
/* function onAISettingModelApplyClick(){

    var jsonmsg = {};

    jsonmsg.Command = "SetCamAISetting";
    jsonmsg.IPAddress = document.getElementById("AISettingModelIPAddress").value;

    if(document.getElementById("AISettingModelInput").checked == true)
        jsonmsg.IsAI_PeopleTrackingEnable = true;
    else
        jsonmsg.IsAI_PeopleTrackingEnable = false;

    jsonmsg.AI_PeopleTrackingMode = parseInt(document.getElementById("SelectAISettingModelPeopleTracking").value,10);

    sendMessageCameralist("SetCamAISetting",jsonmsg);

    $('#AISettingModal').modal('hide');

    document.getElementById("BtnAISettingModalApply").disabled = true;
} */

function FPSOnChange(){

    var FPS = parseInt(document.getElementById("selectFPS").value,10);

    sendMessageCameralist("SetVideoFps",FPS);
}

function ResolutionOnChange(){

    var resolution = document.getElementById("selectResolution").value;

    sendMessageCameralist("SetVideoResolution",resolution);
}

function InputAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}

function SelectAISettingModelPeopleTrackingOnChange(){

    document.getElementById("BtnAISettingModalApply").disabled = false;

}

//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;

function initWebSocketCameralist() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();

        sendMessageIndex("GetCurrentProfileID");
        sendMessageCameralist("GetVideoIsStartStreaming");
        sendMessageCameralist("GetIsNdiMode");
        sendMessageCameralist("GetVideoResolution");
        sendMessageCameralist("GetVideoFps");
//        updateCameraPage(true);
//        sendMessageCameralist("SearchCamera");
//        blockUIforPage();
        sendMessageCameralist("GetCameraList");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();

        sendMessageIndex("GetCurrentProfileID");
        sendMessageCameralist("GetVideoIsStartStreaming");
        sendMessageCameralist("GetIsNdiMode");
        sendMessageCameralist("GetVideoResolution");
        sendMessageCameralist("GetVideoFps");
//        updateCameraPage(true);
//        sendMessageCameralist("SearchCamera");
//        blockUIforPage();
        sendMessageCameralist("GetCameraList");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };

    websocket.addEventListener('message',function(evt){
        //console.log('Message received',evt.data);
        //console.log('Message received');
        if(evt.data instanceof Blob)
        {
            const imgLoader = document.getElementById('cameralist_loader');
            if(imgLoader)
                createImageFromFile(imgLoader, evt.data);
        }
        else
        {
            receivedDataCameralist(evt.data);
        }
    });
}

function createImageFromFile(imgElement, fileBlob) {
    return new Promise((resolve, reject) => {
        const objectURL = URL.createObjectURL(fileBlob);
        imgElement.onload = () => {
            URL.revokeObjectURL(objectURL);
            resolve(imgElement);
        };
        // imgElement.onerror = (error) => {
        //     URL.revokeObjectURL(objectURL); 
        //     reject(new Error('Failed to load image'));
        // };
        imgElement.src = objectURL;
    });
}

function receivedDataCameralist(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);

    //console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply) {

        case "SearchCamera": //reply search camera result
            //console.log('SearchCamera result!!');
            updatedSearchCameraTable(obj);
            if (gIsVideoStart == 1) {
                updateCameraPage(true);
                refreshCameraTable(true);
            }
            else {
                updateCameraPage(false);
                refreshCameraTable(false);
            }
            if (gReloadPageCnt == 1) {
                //console.log('Reload SearchCamera :', gReloadPageCnt);
                reloadCameraTable();
            }
            else {
                //console.log('Normal SearchCamera :', gReloadPageCnt);
                UnblockUIforPage();
            }

            sendMessageCameralist("GetCurrentProfileID");
            
            break;

        case "GetCameraList":
            console.log('GetCameraList!!');
            updatedSearchCameraTable(obj);
            if (gIsVideoStart == 1) {
                updateCameraPage(true);
                refreshCameraTable(true);
            }
            else {
                updateCameraPage(false);
                refreshCameraTable(false);
            }
            gReloadPageCnt = 0; // clear judgement tag
            UnblockUIforPage();
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
            break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;

        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        /* case "GetCamAISetting":
            console.log('GetCamAISetting!!');
            updateCamAISetting(obj);
        break; */

        case "CameraConnect":
            // console.log('CameraConnect Reply!!');
            if(!gCameraDeleteBlockFlag && !gCameraDisconnectBlockFlag && !gCameraSearchBlockFlag)
            {
                UnblockUIforPage();
            }
            updateCamConnect(obj);
        break;

        case "CameraDisconnect":
            // console.log('CameraDisconnect Reply!!');
            if(!gCameraSearchBlockFlag)
            {
                UnblockUIforPage();
            }
            updateCamDisconnect(obj);

        break;

        case "GetVideoResolution":
            console.log('GetVideoResolution!!');
            updateVideoResolution(obj);
        break;

        case "GetVideoFps":
            console.log('GetVideoFps!!');
            updateVideoFps(obj);
            if (gIsVideoStart == 1)
            if(!gCameraSearchBlockFlag)
            {
                UnblockUIforPage();
            }
        break;

        case "GetVideoIsStartStreaming":
            console.log('GetVideoIsStartStreaming!!');
            gIsVideoStart = getVideoStreamingStatus(obj);
        break;

        case "GetFocusMode":
            updatedPTZFocusMode(obj);
        break;

        case "GetMirrorFlipType":
            updatedMirrorFlipType(obj);
        break;

        case "GetPanFlip":
            updatedPanFlip(obj);
        break;

        case "StartVideoStreaming":
            updatedStartVideoStreaming(obj,false);
            updateCameraPage(true);
            refreshCameraTable(true);
        break;

        case "StopVideoStreaming":
            updatedStopVideoStreaming(obj);
            updateCameraPage(false);
            refreshCameraTable(false);
        break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            break;

        case "LoadProfile":
            gReloadPageCnt = 1;
            break;

        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
            break;
        case "GetIsNdiMode":
            //console.log('GetIsNdiMode!!',obj);
            IsEnableAddCamerea(obj);
            break;
    }

}

function IsEnableAddCamerea(msg)
{
    if(msg.IsNDI)
    {
        if(document.getElementById('Label_Manual_IP'))
            document.getElementById('Label_Manual_IP').style.display = 'none';

        if(document.getElementById('CameraIPInput'))
            document.getElementById('CameraIPInput').style.display = 'none';

        if(document.getElementById('Camera_Add'))
            document.getElementById('Camera_Add').style.display = 'none';

    }
    else
    {
        if(document.getElementById('Label_Manual_IP'))
            document.getElementById('Label_Manual_IP').style.display = 'block';

        if(document.getElementById('CameraIPInput'))
            document.getElementById('CameraIPInput').style.display = 'block';

        if(document.getElementById('Camera_Add'))
            document.getElementById('Camera_Add').style.display = 'block';
    }
}

function updatedPTZFocusMode(msg) {

    if(gIsControlByGui)
        return;

    zoneFullMap_updatedPTZFocusMode(msg);

    // console.log('Mode:', msg.Mode);
    
    if(msg.Mode == "Auto"){
        document.getElementById("cameralist_focusModeCheckboxInput").checked = true;
    }
    else
        document.getElementById("cameralist_focusModeCheckboxInput").checked = false;

}

function updatedMirrorFlipType(msg) {

    if(gIsControlByGui)
        return;

    zoneFullMap_updatedMirrorFlipType(msg);
    
    //console.log('Type:', msg.Type);

    document.getElementById("cameralist_PTZMirrorFlipType").value = msg.Type;

}

function updatedPanFlip(msg) {

    if(gIsControlByGui)
        return;

    console.log('IsFlip:', msg.IsFlip);

    if(document.getElementById("cameralist_PTZLRDirection"))
        document.getElementById("cameralist_PTZLRDirection").checked = msg.IsFlip;
    

}

function updateVideoFps(msg) {

    console.log('updateVideoFps');
    $("#selectFPS").val(msg.VideoFps);
}

function updateVideoResolution(msg) {

    console.log('updateVideoResolution');
    $("#selectResolution").val(msg.VideoResolution);
}

function updateCamConnect(msg) {

    //console.log('msg.IPAddress:',msg.IPAddress);
    //console.log('msg.Result:',msg.Result);
    //console.log('updateCamConnect msg:',msg);
    var tableIndex = 0;
    if(document.getElementById("tableSearchCamera"))
        tableIndex = document.getElementById("tableSearchCamera").rows.length;
    var index = 0;
    var isFindCamera = false;
    var isDanteSource = false;
    var danteSourceCountName = "DanteCH01";

    if( 'IsDante' in msg)
        isDanteSource = msg.IsDante;

    for(index= 0 ; index < tableIndex; index++)
    {
        if(isDanteSource)
        {
            if(document.getElementById("cameraName_"+index))
            {
                if(document.getElementById("cameraName_"+index).innerText == msg.DanteSource)
                {
                    var getIpString =  msg.IPAddress;
                    if(getIpString.length > (danteSourceCountName.length+1))
                       getIpString = getIpString.substring(danteSourceCountName.length +1,getIpString.length -1);
                    else
                        getIpString ="";

                    document.getElementById("cameraIP_"+index).innerText =getIpString;

                    isFindCamera = true;
                    break;
                }                  
            }
            
        }
        else
        {
            if(document.getElementById("cameraName_"+index))
            {
                if(document.getElementById("cameraName_"+index).innerText.indexOf("DanteCH")  == -1)
                {
                    if(document.getElementById("cameraIP_"+index))
                    {
                        if(document.getElementById("cameraIP_"+index).innerText == msg.IPAddress)
                        {
                            isFindCamera = true;
                            break;
                        }   
                    }
                }                  
            }
            
        }
    }

    if(isFindCamera)
    {
        let camSourceIp = "";
        if(isDanteSource)
            camSourceIp = msg.DanteSource;
        else
            camSourceIp = msg.IPAddress;

        updateCamTableStatus(index,camSourceIp,msg.Result);
    }
}

function updateCamTableStatus(findCamTableIndex,IpOrLocation,camResult)
{
    document.getElementById("cameraStatus_"+findCamTableIndex).innerText = window.LanguageManager.getTranslatedText(camResult);
    document.getElementById("cameraStatus_"+findCamTableIndex).style.color = "#01e2ff";
    document.getElementById("cameraControl_"+findCamTableIndex).checked = true;
    document.getElementById("cameraName_"+findCamTableIndex).style.color = "#01e2ff";
    document.getElementById("cameraIP_"+findCamTableIndex).style.color = "#01e2ff";
    document.getElementById("camDel_"+findCamTableIndex).style.display = "none";

    if(camResult == 'Disconnecting')
    {
        document.getElementById("cameraControl_"+findCamTableIndex).checked = false;
        document.getElementById("cameraStatus_"+findCamTableIndex).innerText = '';
        document.getElementById("camDel_"+findCamTableIndex).style.display = 'block';
        document.getElementById("cameraStatus_"+findCamTableIndex).style.color = "#ffffff";
        document.getElementById("cameraName_"+findCamTableIndex).style.color = "#ffffff";
        document.getElementById("cameraIP_"+findCamTableIndex).style.color = "#ffffff";
    }
    else
    {
        document.getElementById("cameraControl_"+findCamTableIndex).checked = true;
    }

    // console.log('msg.IPAddress:',msg.IPAddress);
    // console.log('msg.Result:',msg.Result);
    // console.log('updateCamConnect msg:',msg);

    if(camResult == window.LanguageManager.getTranslatedText('Connected') 
    || camResult == window.LanguageManager.getTranslatedText('Disconnecting')
    || camResult == 'Disconnecting'
    || camResult == window.LanguageManager.getTranslatedText('Ready') 
    || camResult == 'Ready'
    || camResult == 'Pending'
    || camResult == '')
    {
        document.getElementById("cameraStatus_"+findCamTableIndex).style.paddingLeft = '16px';
        document.getElementById("cameraStatusimg_"+findCamTableIndex).style.display = 'none';
    }
    else
    {
        document.getElementById("cameraStatus_"+findCamTableIndex).style.paddingLeft = '0px';
        document.getElementById("cameraStatusimg_"+findCamTableIndex).style.display = 'block';
    }

    gCameraConnectSet.add(IpOrLocation);

    if(camResult == window.LanguageManager.getTranslatedText('Disconnecting') || camResult == 'Disconnecting' || camResult == '')
    {
        gCameraConnectSet.delete(IpOrLocation);
    }

    gCameraConnCnt = gCameraConnectSet.size;
    //console.log('gCameraConnectSet.size : ',gCameraConnectSet.size);
    DisableResolutonAndFps(true);
}

function updateCamDisconnect(msg) {
    // console.log('msg.IPAddress:', msg.IPAddress);
    // console.log('msg.Result:', msg.Result);
    var tableIndex = document.getElementById("tableSearchCamera").rows.length;
    var index = 0;
    var isFindCamera = false;

    for (index = 0 ; index < tableIndex; index++) {
        if (document.getElementById("cameraIP_" + index).innerText == msg.IPAddress) {
            isFindCamera = true;
            break;
        }
    }

    if(isFindCamera)
    {
        if(msg.Result == 'Success')
        {
            document.getElementById("cameraStatusimg_"+index).style.display = 'none';

            setTimeout(()=> {
                document.getElementById("cameraStatus_"+index).innerText = '';
                document.getElementById("camDel_"+index).disabled = false;
            },100);
        }

        document.getElementById("cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById("cameraControl_"+index).checked = false;
        document.getElementById("cameraName_"+index).style.color = "#ffffff";
        document.getElementById("cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("camDel_"+index).style.display = "block";
        document.getElementById("camDel_"+index).disabled = true;
        gCameraConnectSet.delete(msg.IPAddress);
        gCameraConnCnt = gCameraConnectSet.size;
        gCameraConnCnt--;
        if (gCameraConnCnt > 0)
            DisableResolutonAndFps(true);
        else
            DisableResolutonAndFps(false);
    }
}

function DisableResolutonAndFps(status) {

    document.getElementById("selectResolution").disabled = status;
    document.getElementById("selectFPS").disabled = status;
}

let gdeleteClickTimeout = null;
let glastDeleteClickTime = 0;
let glastConnectClickTime = 0;
let glastonSearchCameraClickTime = 0;


function disableLabelCameraSearchButton() 
{
    blockUIforPage();

    const searchBtn = document.getElementById('LabelCameraSearch');
    const CameraIPInput = document.getElementById('CameraIPInput');
    const selectFPS = document.getElementById('selectFPS');
    const selectResolution = document.getElementById('selectResolution');

    if (searchBtn) 
    {
        searchBtn.disabled = true;
        
        setTimeout(() => {
            searchBtn.disabled = false;
        }, 2000);
    }
    if (CameraIPInput) 
    {
        CameraIPInput.disabled = true;
        
        setTimeout(() => {
            CameraIPInput.disabled = false;
        }, 2000);
    }
    if (selectFPS) 
    {
        selectFPS.disabled = true;
        
        setTimeout(() => {
            selectFPS.disabled = false;
        }, 2000);
    }
    if (selectResolution) 
    {
        selectResolution.disabled = true;
        
        setTimeout(() => {
            selectResolution.disabled = false;
        }, 2000);
    }

    if(gCameraDeleteBlockFlag)
    {
        setTimeout(() => {
            gCameraDeleteBlockFlag = false;
            UnblockUIforPage();
            setTimeout(() => {
                UnblockUIforPage();
            }, 100);
            setTimeout(() => {
                UnblockUIforPage();
            }, 200);
        }, 5000);
    }

    if(gCameraDisconnectBlockFlag)
    {
        setTimeout(() => {
            gCameraDisconnectBlockFlag = false;
            UnblockUIforPage();
            setTimeout(() => {
                UnblockUIforPage();
            }, 100);
            setTimeout(() => {
                UnblockUIforPage();
            }, 200);
        }, 3000);
    }

    setTimeout(() => {
        UnblockUIforPage();
        setTimeout(() => {
            UnblockUIforPage();
        }, 100);
        setTimeout(() => {
            UnblockUIforPage();
        }, 200);
    }, 5000);

}


var gCameraDeleteBlockFlag = false;
var gCameraDisconnectBlockFlag = false;
var gCameraSearchBlockFlag = false;
let camWithFriendlyName = new Map();

function updatedSearchCameraTable(msg) {

    camWithFriendlyName.clear();
    var table = document.getElementById("tableSearchCamera");
    if(!table) return;
    var curCameraTableCnt = table.rows.length;
    var index = 0;
    var rowlast;
    var celllast;
    var danteSourceCountName = "DanteCH01";

    gCameraSearchBlockFlag = false;
    // console.log('msg.cameraCnt:',msg.CameraCount);
    // console.log('curCameraTableCnt:',curCameraTableCnt);
    // console.log(JSON.stringify(msg));

    //delete all table content
    if(curCameraTableCnt > 1){
        for(index=curCameraTableCnt;index > 1 ;index--){
            table.deleteRow(index-1);
        }
    }

    gCameraConnectSet.clear();
    gCameraConnCnt = 0;
    //update table content
    let imgSrc = "../imageslm/YellowWarning_3.png";
    for(index=0;index < msg.CameraCount; index++){

        rowlast = table.insertRow(); //add row

        celllast = rowlast.insertCell();//add colum
        celllast.innerHTML="<label id =\"cameraName_"+index+"\" class=\"Font_Arial_14 camHeadField\" disabled ></label>";

        celllast = rowlast.insertCell();
        celllast.innerHTML="<label id =\"cameraIP_"+index+"\" class=\"Font_Arial_14 camInfoField \"></label>";

        celllast = rowlast.insertCell();

        celllast.innerHTML = `
            <div id="cameraStatusDiv_${index}" style="height: 40px; display: flex; align-items: center; justify-content: center; border-bottom: 1px solid rgba(137, 207, 216, 1);">
                <img id="cameraStatusimg_${index}" src="${imgSrc}" style="width: 16px; height: 16px; background: transparent; border: none; vertical-align: middle; margin-right: 5px; display: none;">
                <label id="cameraStatus_${index}" class="Font_Arial_14 camInfoStatusField"></label>
            </div>
        `;

        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraCtrl_" + index + "\" class=\"camCtrlField\"><label class=\"switch_onoff\"><input type=\"checkbox\" id=\"cameraControl_" + index + "\"><span class=\"slider_onoff\"></label></label>";

        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraPTZ_" + index + "\" class=\"camMiscField\" valign=\"middle\"><button id=\"camPTZCtrl_" + index + "\" class=\"Btn_ptzctrl\" ><span id = \"Label_PTZ_Control\">PTZ Control</span></button></label>";

//        celllast = rowlast.insertCell();
//        celllast.innerHTML = "<label id =\"cameraAIS_" + index + "\" class=\"camMiscField\" valign=\"middle\"><button id=\"camAISet_" + index + "\" class=\"Btn_ptzctrl\" >AI Setting</button></label>";

        celllast = rowlast.insertCell();
        celllast.innerHTML = "<label id =\"cameraDel_" + index + "\" class=\"camTailField\"><button id=\"camDel_" + index + "\" class=\"Btn_Del margin-left-24px margin-top-4px\" >&nbsp;</button></label>";

        //update camera information
        let camFriendlyName =  msg.CamerasArray[index].FriendlyName;
        camWithFriendlyName.set(index,camFriendlyName);
        if(camFriendlyName.length >=32)
        {       
            camFriendlyName =  camFriendlyName.substring(0,29);
            camFriendlyName = camFriendlyName.padEnd(32,".");
        }
        document.getElementById("cameraName_"+index).innerText = camFriendlyName;
        if(msg.CamerasArray[index].IsDanteSource)
        {
            var getIpString =  msg.CamerasArray[index].DisplayName;
            if(getIpString.length > (danteSourceCountName.length+1))
                getIpString = getIpString.substring(danteSourceCountName.length+1,getIpString.length -1);
            else
                getIpString = "";

            document.getElementById("cameraIP_"+index).innerText =getIpString;
        }
        else
            document.getElementById("cameraIP_"+index).innerText = msg.CamerasArray[index].IPAddress;

        if(msg.CamerasArray[index].IsConnect == "0")
        {
            document.getElementById("cameraStatus_"+index).innerText = "";           
            document.getElementById("cameraStatusDiv_"+index).style.color = "#ffffff";
            document.getElementById("cameraStatus_"+index).style.color = "#ffffff";
            document.getElementById("cameraControl_"+index).checked = false;
            document.getElementById("cameraName_"+index).style.color = "#ffffff";
            document.getElementById("cameraIP_"+index).style.color = "#ffffff";
            document.getElementById("camDel_"+index).style.display = "block";
            gCameraConnectSet.delete(msg.CamerasArray[index].IPAddress);
        }
        else
        {
            if(msg.CamerasArray[index].IsDanteSource)
                document.getElementById("cameraStatus_"+index).innerText = msg.CamerasArray[index].ConnectStatus;

            document.getElementById("cameraStatusDiv_"+index).style.color = "#01e2ff";
            document.getElementById("cameraStatus_"+index).style.color = "#01e2ff";
            document.getElementById("cameraControl_"+index).checked = true;
            document.getElementById("cameraName_"+index).style.color = "#01e2ff";
            document.getElementById("cameraIP_"+index).style.color = "#01e2ff";
            document.getElementById("camDel_"+index).style.display = "none";
            //gCameraConnCnt++;
            gCameraConnectSet.add(msg.CamerasArray[index].IPAddress);
        }

        if(msg.CamerasArray[index].IsDanteSource)
        {
            document.getElementById("cameraControl_"+index).disabled = true ;
        }

        if(document.getElementById("cameraStatusimg_"+(index)))
        {
            document.getElementById("cameraStatusimg_"+(index)).addEventListener("mouseout", onMouseoutCamStatus);
            document.getElementById("cameraStatusimg_"+(index)).addEventListener("mouseover", onMouseoverCamStatus);
        }
        
    }

    gCameraConnCnt = gCameraConnectSet.size;
    //Disable Resolution&FPS, if it has any camera status is connected
    if(gCameraConnCnt > 0)
        DisableResolutonAndFps(true);

    $(".mytable td").click(function(){
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        gTableRowIndex = trSeq;
        //alert( (tdSeq + 1) + "col，" + (trSeq + 1) + "row");

        if(trSeq > 0 ){

            /* if(tdSeq == 3 ){ //camera connect
                // CameraConnClick(trSeq);
            }else if(tdSeq == 4 ){ //PTZControl
                PTZControl();
            }else if(tdSeq == 5 ){ //AI setting
                AiSettingClick(trSeq);
            }else if(tdSeq == 6 ){ //Table access
                DeleteCameraClick(trSeq);
            } */
            if (tdSeq == 4 ) 
            {                

                var deleteElement = $(this).find('button, img, div').first();
                if (deleteElement.length && deleteElement.css('display') === 'none') {
                    return;
                }
                gCurrentOperationTableRowIndex = gTableRowIndex;
                createCameraPTZWindows();
                PTZControl(); //PTZControl
            }
            else if (tdSeq == 5 ) 
            {
                var deleteElement = $(this).find('button, img, div').first();
                if (deleteElement.length && deleteElement.css('display') === 'none') {
                    return;
                }
                const now = Date.now();
                if (now - glastDeleteClickTime < 1000) 
                {
                    return;
                }
                glastDeleteClickTime = now;
                gCameraDeleteBlockFlag = true;
                disableLabelCameraSearchButton();
                DeleteCameraClick(trSeq); //Table access
            }
        }
    });

    $(".mytable td").change(function () {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        gTableRowIndex = trSeq;
        //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        if (trSeq > 0) 
        {
            if (tdSeq == 3 ) 
            {
                const now = Date.now();
                if (now - glastConnectClickTime < 2000)
                {
                    return;
                }
                glastConnectClickTime = now;
                CameraConnClick(trSeq); //camera connect
            }
        }
    });

    $(".mytable tr").mouseover(function () {
        var trSeq = $(this).parent().find("tr").index($(this)[0]);
        gTableRowIndex = trSeq;
        if (trSeq > 0) {
            CamListHover(trSeq);
        }
        
    });

    $(".mytable tr").mouseout(function () {
        var trSeq = $(this).parent().find("tr").index($(this)[0]);
        gTableRowIndex = trSeq;
        if (trSeq > 0) {
            CamListHoverOut(trSeq);
        }
    });

    $(".mytable td").mouseover(function (eventCamName) {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        gTableRowIndex = trSeq;
        //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        //console.log("Full Friendly Name : ", camWithFriendlyName.get(gTableRowIndex-1));
        
        if (trSeq > 0) 
        {
            if (tdSeq == 0 ) 
            {
             
                var fullCamFriendlyName = camWithFriendlyName.get(gTableRowIndex-1);
                if(fullCamFriendlyName.length >=32)
                {
                    var tooltip = document.getElementById('camNameTooltip');
                
                    var selectedText =fullCamFriendlyName;// document.getElementById("cameraName_"+(gTableRowIndex-1)).innerText;

                    var charWidth = 10; 
                    var tooltipWidth = selectedText.length * charWidth;
                    var maxWidth = 500;
                    tooltip.style.width = Math.min(tooltipWidth, maxWidth) + 'px';  

                    tooltip.textContent = selectedText;
                    tooltip.style.left = eventCamName.clientX+10 +window.scrollX + 'px';
                    tooltip.style.top = eventCamName.clientY +window.scrollY + 'px';
                    tooltip.style.display = 'block';
                }
            }
        }
        
    });

    $(".mytable td").mouseout(function (eventCamName) {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        gTableRowIndex = trSeq;
        //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        if (trSeq > 0) 
        {
            if (tdSeq == 0 ) 
            {
                var tooltip = document.getElementById('camNameTooltip');
                tooltip.style.display = 'none';
            }
        }
    });

    window.LanguageManager.InitLanguageOfPage();

}

function updateCameraPage(status) {
    if (document.getElementById("selectResolution")) {
        // Camera List Items
        if (gCameraConnCnt > 0) {
        document.getElementById("selectResolution").disabled = true;
        document.getElementById("selectFPS").disabled = true;
        }
        else {
        document.getElementById("selectResolution").disabled = status;
        document.getElementById("selectFPS").disabled = status;
        }
        document.getElementById("LabelCameraSearch").disabled = status;
        document.getElementById("CameraIPInput").disabled = status;
        document.getElementById("Camera_Add").disabled = status;
        // Camera List Items
    }
    // document.getElementById("Select_Profile").disabled = status;
}

function refreshCameraTable(status) {
    var table = document.getElementById("tableSearchCamera");
    var currTblCnt;
    if(table) currTblCnt = table.rows.length;
    else return;

    //console.log('currTblCnt :', currTblCnt);
    if (currTblCnt > 1) {
        for (var index = 0; index < (currTblCnt - 1); index++) {

            if(document.getElementById("cameraName_"+index).innerText.indexOf("DanteCH") >= 0)
                document.getElementById("cameraControl_" + index).disabled = true;
            else
                document.getElementById("cameraControl_" + index).disabled = status;

            document.getElementById("camPTZCtrl_" + index).disabled = status;
//            document.getElementById("camAISet_" + index).disabled = status;
            document.getElementById("camDel_" + index).disabled = status;
            document.getElementById("camPTZCtrl_" + index).style.background = getBtnGradBg(false);
            document.getElementById("camPTZCtrl_" + index).style.color = getBtnColor(false);
//            document.getElementById("camAISet_" + index).style.background = getBtnGradBg(false);
//            document.getElementById("camAISet_" + index).style.color = getBtnColor(false);
            document.getElementById("camDel_" + index).style.backgroundImage = getDelBtnBgImg(false);
        }
    }
    else
        onSearchCamera();
}

function getBtnGradBg(hover) {
    if (gIsVideoStart == 1) {
        return 'rgba(79, 79, 90, 1)';
    }
    else {
      /*if (hover)
        return 'linear-gradient(180deg, rgba(137, 207, 216, 1) 0%, rgba(137, 207, 216, 1) 83.33%, rgba(108, 116, 122, 1) 96.35%)';
      else*/
        return 'linear-gradient(180deg, rgba(26, 34, 41, 1) 0%, rgba(0, 14, 26, 1) 100%)';
    }
}

function getBtnColor(hover) {
    if (gIsVideoStart == 1) {
        return 'rgba(123, 123, 123, 1)';
    }
    else {
      /*if (hover)
        return 'rgba(19, 19, 19, 1)';
      else*/
        return 'rgba(137, 207, 216, 1)';
    }
}

function getDelBtnBgImg(hover) {
    if (gIsVideoStart == 1) {
        return 'url("../imageslm/Subtract_disabled.png")';
    }
    else {
        if (hover)
            return 'url("../imageslm/Subtract_hover.png")';
        else
            return 'url("../imageslm/Subtract.png")';
    }
}

function onMouseoverCamStatus (eventCameraName){
    var selectElement = eventCameraName.target;
    var tooltip = document.getElementById('camNameTooltip');
    
        
    //console.log("selectElement.id ",selectElement.id );
    //console.log("tooltip.id ",tooltip.id );

    if (selectElement.style.display === 'block')
    {
        tooltip.textContent = window.LanguageManager.getTranslatedText("Cam_ConnectError_Hint");

        var charWidth = 10; 
        var tooltipWidth = tooltip.textContent.length * charWidth;
        var maxWidth = 200;
        tooltip.style.width = Math.min(tooltipWidth, maxWidth) + 'px';  
        tooltip.style.height = 32+'px';

       
        tooltip.style.left = eventCameraName.clientX+10+window.scrollX + 'px';
        tooltip.style.top = eventCameraName.clientY+window.scrollY + 'px';
        
        tooltip.style.display = 'block';
        
    }
}


function onMouseoutCamStatus(eventCameraName) {
    var selectElement = eventCameraName.target;
    //selectElement.classList.remove('cameraSelectHovered');
    var tooltip = document.getElementById('camNameTooltip');   
    tooltip.style.display = 'none';
}

function CamListHover(rowIdx) {
//    console.log('row : ', rowIdx);
    var index  = rowIdx - 1;
    var status = document.getElementById("cameraControl_"+index).checked;

    document.getElementById("cameraName_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraIP_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraStatus_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraStatusDiv_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraCtrl_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraPTZ_"+index).style.backgroundColor = "#01b5cc";
    document.getElementById("cameraDel_"+index).style.backgroundColor = "#01b5cc";
    if (status == false) {
        document.getElementById("cameraName_"+index).style.color = "#ffffff";
        document.getElementById("cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById("cameraStatusDiv_"+index).style.color = "#ffffff";
        document.getElementById("camDel_"+index).style.backgroundImage = getDelBtnBgImg(true);
    }
    else {
        document.getElementById("cameraName_"+index).style.color = "#131313";
        document.getElementById("cameraIP_"+index).style.color = "#131313";
        document.getElementById("cameraStatus_"+index).style.color = "#131313";
        document.getElementById("cameraStatusDiv_"+index).style.color = "#131313";
    }
    document.getElementById("camPTZCtrl_" + index).style.background = getBtnGradBg(true);
    document.getElementById("camPTZCtrl_" + index).style.color = getBtnColor(true);
}

function CamListHoverOut(rowIdx) {
//    console.log('row : ', rowIdx);
    var index  = rowIdx - 1;
    var status = document.getElementById("cameraControl_"+index).checked;

    document.getElementById("cameraName_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraIP_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraStatus_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraStatusDiv_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraCtrl_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraPTZ_"+index).style.backgroundColor = "#000000";
    document.getElementById("cameraDel_"+index).style.backgroundColor = "#000000";
    if (status == false) {
        document.getElementById("cameraName_"+index).style.color = "#ffffff";
        document.getElementById("cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById("cameraStatusDiv_"+index).style.color = "#ffffff";
        document.getElementById("camDel_"+index).style.backgroundImage = getDelBtnBgImg(false);
    }
    else {
        document.getElementById("cameraName_"+index).style.color = "#01e2ff";
        document.getElementById("cameraIP_"+index).style.color = "#01e2ff";
        document.getElementById("cameraStatus_"+index).style.color = "#01e2ff";
        document.getElementById("cameraStatusDiv_"+index).style.color = "#01e2ff";
    }
    document.getElementById("camPTZCtrl_" + index).style.background = getBtnGradBg(false);
    document.getElementById("camPTZCtrl_" + index).style.color = getBtnColor(false);
}

function CameraConnClick(rowIndex){

    var index  = rowIndex;
    var ip     = document.getElementById("cameraIP_"+(index-1)).innerText;
    var status = document.getElementById("cameraControl_"+(index-1)).checked;

    if(document.getElementById("cameraName_"+(index-1)).innerText.indexOf("DanteCH") >= 0)
        return;

    const now = Date.now();
    if (now - glastDeleteClickTime < 1000) 
    {
        return;
    }
    glastDeleteClickTime = now;

    //console.log("CameraConnClick", rowIndex, ip, 'status : ',status,gCameraConnCnt);

    if (status == true)
    {
        if(gCameraConnCnt < 4 )
        {
            sendMessageCameralist("CameraConnect",ip);
            blockUIforPage();
        }
        else
            document.getElementById("cameraControl_"+(index-1)).checked = false;
    }
    else
    {
        if(document.getElementById("cameraStatus_"+(index-1)))
            document.getElementById("cameraStatus_"+(index-1)).innerText = window.LanguageManager.getTranslatedText('Disconnecting');
        if(document.getElementById("cameraStatusimg_"+(index-1)))
            document.getElementById("cameraStatusimg_"+(index-1)).style.display = 'none';

        sendMessageCameralist("CameraDisconnect",ip);
        gCameraDisconnectBlockFlag = true;
    }

    disableLabelCameraSearchButton();
}

function saveTableToJson(rmIdx) {
    var table = document.getElementById("tableSearchCamera");
    var currTblCnt = table.rows.length;
    var tmp_data = [];

    //console.log("currTblCnt :", currTblCnt, " rmIdx :", rmIdx);
    if (currTblCnt <= 1)
        return;

    cam_json = {};
    if (JSON.stringify(cam_json).lenght === 0 || '{}') {
        // console.log(JSON.stringify(cam_json)); // {} will be output but a string type.
        console.log('Object is empty');
    };

    // go through cells
    for (var i = 1; i < currTblCnt; i++) {
        if (i == rmIdx)
            continue;
        var tableRow = table.rows[i];
        var rowData = {};
        var status = tableRow.cells[2].innerText;
        rowData[ "FriendlyName" ] = tableRow.cells[0].innerText;
        rowData[ "IPAddress" ] = tableRow.cells[1].innerText;
        if (document.getElementById("cameraControl_"+(i-1)).checked == true)
            rowData[ "IsConnect" ] = "1";
        else
            rowData[ "IsConnect" ] = "0";
        if (status === 'Connected')
            rowData[ "ConnectStatus" ] = '';
        else
            rowData[ "ConnectStatus" ] = tableRow.cells[2].innerText;
        tmp_data.push(rowData);
    }
    cam_json[ "CameraCount" ] = currTblCnt - 2;
    cam_json[ "CamerasArray" ] = tmp_data;
    // console.log(JSON.stringify(cam_json));
}

function tableToJson() {
    var table = document.getElementById("tableSearchCamera");
    var currTblCnt = table.rows.length;
    var tmp_data = [];
    var json_obj = {};

    if (currTblCnt <= 1)
        return;

    // go through cells
    for (var i = 1; i < currTblCnt; i++) {
        var tableRow = table.rows[i];
        var rowData = {};
        rowData[ "FriendlyName" ] = tableRow.cells[0].innerText;
        rowData[ "IPAddress" ] = tableRow.cells[1].innerText;
        if (document.getElementById("cameraControl_"+(i-1)).checked == true)
            rowData[ "IsConnect" ] = "1";
        else
            rowData[ "IsConnect" ] = "0";
        rowData[ "ConnectStatus" ] = tableRow.cells[2].innerText;
        tmp_data.push(rowData);
    }
    json_obj[ "CameraCount" ] = currTblCnt - 1;
    json_obj[ "CamerasArray" ] = tmp_data;
    console.log(JSON.stringify(json_obj));
    updatedSearchCameraTable(json_obj);
}

function DeleteCameraClick(rowIndex) {
    var index = rowIndex;
    var ip_usb = document.getElementById("cameraIP_"+(index-1)).innerText;
    var table = document.getElementById("tableSearchCamera");

    if (gIsVideoStart == 1)
        return;
    //console.log("Curr Camera row-index :", index, " name : ", ip_usb);
    if (document.getElementById("cameraControl_"+(index-1)).checked == false)
    {
        sendMessageCameralist("DeleteCamera", ip_usb); // Delete Camera by IP or UsbLocation
        saveTableToJson(index);
        //delete table content
        table.deleteRow(index);
        // tableToJson();
        updatedSearchCameraTable(cam_json);
    }
}

function GetPTZInfo(CameraIP) {

    if(gIsControlByGui)
        return;

    var jsonmsg = {};

    jsonmsg.Command = "GetFocusMode";
    jsonmsg.IPAddress = CameraIP;
    sendMessageCameralist("GetFocusMode",jsonmsg);

    jsonmsg.Command = "GetMirrorFlipType";
    jsonmsg.IPAddress = CameraIP;
    sendMessageCameralist("GetMirrorFlipType",jsonmsg);

    jsonmsg.Command = "GetPanFlip";
    jsonmsg.IPAddress = CameraIP;
    sendMessageCameralist("GetPanFlip",jsonmsg);
}

function PTZControl() {
    if(gIsControlByGui)
        return;
    var url = 'http://'+ document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var CameraPTZ = document.getElementById('cameralist_CameraPTZWindows');
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var danteSourceName = "";
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        danteSourceName = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    var ch = '.';
    var count = cameraIP.split(ch).length - 1;
    if (gIsVideoStart == 1)
        return;
    console.log(count);

    console.log("PTZ Control TableRowIndex:",gCurrentOperationTableRowIndex-1);
    console.log("PTZ Control IP:",cameraIP);

    if (document.getElementById("cameraControl_"+(gCurrentOperationTableRowIndex-1)).checked == true) 
    {
        if (count == 3 || isDante ) {//ip camera
            //window.open(url);
            
            CameraPTZ.style.display = 'block';
            var jsonmsg = {};
            jsonmsg.Command = "SetWebPreview";
            if(isDante)
                jsonmsg.IPAddress = danteSourceName;
            else
                jsonmsg.IPAddress = cameraIP;
            jsonmsg.IsPreview = true;
            sendMessageCameralist(jsonmsg.Command,jsonmsg);
        }
        else 
        {
            CameraPTZ.style.display = 'block';
            var jsonmsg = {};
            jsonmsg.Command = "SetWebPreview";
            jsonmsg.IPAddress = cameraIP;
            jsonmsg.IsPreview = true;
            sendMessageCameralist(jsonmsg.Command,jsonmsg);   
        }
        if(isDante)
            GetPTZInfo(danteSourceName);
        else
            GetPTZInfo(cameraIP);
        disabledLeftMenuOnPopWindowOpen();
    }
    else {
        alert(window.LanguageManager.getTranslatedText("PTZ_Control_only_available_while_camera_is_connected"));
    }

}

function imgSrcChange() {
    dmsimg = document.getElementById("cameralist_loader");

    var imgsrc = dmsimg.src;
    var result = imgsrc.indexOf("_A");

    if (result == -1)
        dmsimg.src ="http://"+location.hostname+"/dms_"+gUsbLocation+"_A.jpg";
    else
        dmsimg.src ="http://"+location.hostname+"/dms_"+gUsbLocation+"_B.jpg";
}

function sendMessageCameralist(cmd,data) {
    var msg = cmd;

    if ( websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if(msg == "AddCamera"){
            jsonmsg.IPAddress = data; //AddCamera
        }
        else if(msg == "DeleteCamera"){
            jsonmsg.Camera = data; // IP or UsbLocation
        }
        /* else if(msg == "GetCamAISetting"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetCamAISetting"){
            jsonmsg = data;
        } */
        else if(msg == "CameraConnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "CameraDisconnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "SetVideoResolution"){
            jsonmsg.VideoResolution = data;
        }
        else if(msg == "SetVideoFps"){
            jsonmsg.VideoFps = data;
        }
        else if(msg == "GetFocusMode" || msg == "GetMirrorFlipType" || msg == "GetPanFlip"){
            jsonmsg = data;
        }
        else if(msg == "SetPanTiltStart" || msg == "SetPanTiltStop" || msg == "SetPanTiltHome"){
            jsonmsg = data;
        }
        else if(msg == "SetFocusStop" || msg == "SetFocusStart"){
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart"){
            jsonmsg = data;
        }
        else if(msg == "SetMirrorFlip" || msg == "SetPanFlip" || msg == "SetFocusMode"){
            jsonmsg = data;
        }
        else if(msg == "SetToCallPreset" || msg == "SetToSavePreset"){
            jsonmsg = data;
        }
        else if(msg == "SetWebPreview"){
            jsonmsg = data;
        }

        //var jsonmsg = {
        //   Command : msg
            //ws_msg : msg//"49.138077,-122.857472"
        //};
        if (websocket.readyState == 1) {
        websocket.send( JSON.stringify(jsonmsg) );
        //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}


function onSearchCamera() {

    const now = Date.now();
    if (now - glastonSearchCameraClickTime < 5000) 
    {
        return;
    }
    glastonSearchCameraClickTime = now;

    updateCameraPage(true);
    sendMessageCameralist("SearchCamera");
    
    gCameraSearchBlockFlag = true;
    blockUIforPage();
    setTimeout(function () {

        if(gCameraSearchBlockFlag)
        {
            gCameraSearchBlockFlag = false;
            UnblockUIforPage();

            if (gIsVideoStart == 1) {
                updateCameraPage(true);
                refreshCameraTable(true);
            }
            else {
                updateCameraPage(false);
                refreshCameraTable(false);
            }
        }
    },5100);

}

function onAddCamera() {

    var data = document.getElementById("CameraIPInput").value ;//get camera IP

    sendMessageCameralist("AddCamera",data);
}


function sendStorePresetCmd(strSet) {
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    jsonmsg.Command   = "SetToSavePreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessageCameralist("SetToSavePreset",jsonmsg);
}

function sendRecallPresetCmd(strSet) {
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    jsonmsg.Command   = "SetToCallPreset";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Preset    = parseInt(strSet,10);
    sendMessageCameralist("SetToCallPreset",jsonmsg);
}

function presetTextAction(strSet) {
    var strVal = $("#cameralist_presetInput").val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            if (strVal == "0") {
                strVal = strSet;
            } else {
                strVal = strVal.concat(strSet);
            }
            break;
        case 2:
            if (strSet < "6") {
                if (strVal <= "25") {
                    strVal = strVal.concat(strSet);
                }
                //else do nothing
            } else {
                if (strVal <= "24") {
                    strVal = strVal.concat(strSet);
                }
            }
            break;
        case 3:
            //do nothing
            break;
        case 4:
            strVal = "";
            break;
    }
    $("#cameralist_presetInput").val(strVal);
}

function PTZMirrorFlipTypeChange() {
    var jsonmsg = {};
    var value = document.getElementById("cameralist_PTZMirrorFlipType").value;
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    jsonmsg.Command   = "SetMirrorFlip";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Type      = parseInt(value,10);
    sendMessageCameralist("SetMirrorFlip",jsonmsg);
}

function focusModeChange(e) {
    var jsonmsg  = {};
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }
    var focusMode;

    if (e.checked == false) {
        focusMode = "Manual";
    }
    else {
        focusMode = "Auto";
    }

    jsonmsg.Command   = "SetFocusMode";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.Mode      = focusMode;
    sendMessageCameralist("SetFocusMode",jsonmsg);
}

var ptCmdRun = false;
var focusCmdRun = false;
var zoomCmdRun = false;

// PanTilt control
function sendPanTiltCmd(dir) {
    var ptzcmd;
    var jsonmsg = {};
    if(!document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1))) 
        return;
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    console.log("sendPanTiltCmd TableRowIndex:",gCurrentOperationTableRowIndex-1);
    console.log("sendPanTiltCmd IP:",cameraIP);

    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    }
    else if (dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    }
    else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageCameralist(ptzcmd,jsonmsg);
}

function stopPanTiltMoving() {
    if (ptCmdRun == false)
        return;
    ptCmdRun = false;
    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        sendPanTiltCmd(dir);
    }, 500);
}

function PanTiltElement() {
    var dir;
    $('#cameralist_ptDownLeftButton').on({
        mousedown: function (e) {
            dir = 'LeftDown';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptDownButton').on({
        mousedown: function (e) {
            dir = 'Down';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptDownRightButton').on({
        mousedown: function (e) {
            dir = 'RightDown';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptLeftButton').on({
        mousedown: function (e) {
            dir = 'Left';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });

    $('#cameralist_HomeButton').on({
        mousedown: function (e) {
            dir = 'home';
            sendPanTiltCmd(dir);
        }
    });

    $('#cameralist_ptRightButton').on({
        mousedown: function (e) {
            dir = 'Right';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptUpLeftButton').on({
        mousedown: function (e) {
            dir = 'LeftUp';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptUpButton').on({
        mousedown: function (e) {
            dir = 'Up';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
    $('#cameralist_ptUpRightButton').on({
        mousedown: function (e) {
            dir = 'RightUp';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTiltCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPanTiltMoving();
        },
        mouseleave: function () {
            stopPanTiltMoving();
        }
    });
}

//Focus control
function sendManualFocusCmd(dir) {
    var focuscmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    if (dir == 'stop') {
        focuscmd = "SetFocusStop";
    }
    else {
        focuscmd = "SetFocusStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = focuscmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageCameralist(focuscmd,jsonmsg);
}

function stopFocusMoving() {
    if (focusCmdRun == false)
        return;
    focusCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        sendManualFocusCmd('stop');
    }, 500);
}

function ManualFocusControl() {
    $('#cameralist_focusNearButton').on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                sendManualFocusCmd('Near');
            }, 100);
        },
        mouseup: function () {
            stopFocusMoving();
        },
        mouseleave: function () {
            stopFocusMoving();
        }
    });

    $('#cameralist_focusFarButton').on({
        mousedown: function (e) {
            focusCmdRun = true;
            setTimeout(function () {
                sendManualFocusCmd('Far');
            }, 100);
        },
        mouseup: function () {
            stopFocusMoving();
        },
        mouseleave: function () {
            stopFocusMoving();
        }
    });
}

//Zoom control
function sendZoomStopCmd() {
    if (zoomCmdRun == false)
        return;
    zoomCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        sendZoomCmd('Stop');
    }, 500);
}

function sendZoomCmd(telewide) {
    var zoomcmd;
    var jsonmsg = {};
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }

    if (telewide == 'Stop') {
        zoomcmd = "SetZoomStop";
    }
    else {
        zoomcmd = "SetZoomStart";
        jsonmsg.Direction = telewide;
    }

    jsonmsg.Command   = zoomcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageCameralist(zoomcmd,jsonmsg);
}

function ZoomBtnElements() {
    $('#cameralist_zoomWideButton').on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                sendZoomCmd('Out');
            }, 100);
        },
        mouseup: function () {
            sendZoomStopCmd();
        },
        mouseleave: function () {
            sendZoomStopCmd();
        }
    });

    $('#cameralist_zoomTeleButton').on({
        mousedown: function (e) {
            zoomCmdRun = true;
            setTimeout(function () {
                sendZoomCmd('In');
            }, 100);
        },
        mouseup: function () {
            sendZoomStopCmd();
        },
        mouseleave: function () {
            sendZoomStopCmd();
        }
    });
}

function reloadCameraTable() {
    console.log('reloadCameraTable');
    setTimeout(function () {
        sendMessageCameralist("GetCameraList");
    }, 20000);
}

function openCameraList() {
    $("#DivMainPage").load("./page/cameralist.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        initWebSocketCameralist();

        $( "#BtnAISettingModalClose" ).click(function() {//close modal
            $('#AISettingModal').modal('hide');
        });

        $( "#BtnRightUpClose" ).click(function() {//close modal
            $('#AISettingModal').modal('hide');
        });

        $( "#BtnPTZModalClose" ).click(function() {//close modal

            if (gPTZTimerId != null) {
                clearInterval(gPTZTimerId);
                gPTZTimerId = null;
            }
            $('#PTZModal').modal('hide');
        });

        PanTiltElement();
        ManualFocusControl();
        ZoomBtnElements();

        //Preset
        $("#presetInput").change(function () {
            filterNumberInRange(this, 0, 255);
        });

        $("#presetRecallButton").on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetCall", $("#presetInput").val());
            sendRecallPresetCmd($("#presetInput").val());
            $("#presetInput").val("");
        });

        $("#presetStoreButton").on('click', function () {
            //sendSingleCGICmd("presetposition", "PresetSet", $("#presetInput").val());
            sendStorePresetCmd($("#presetInput").val());
            $("#presetInput").val("");
        });

        document.getElementById("Select_Profile").style.display = "block";
        document.getElementById("Label_Profile").style.display = "block";
    });
}

// Disable contextmenu
$(document).on("contextmenu", function (e) {
    return false;
});

// Disable "Esc", "F5" and "Ctrl + R"
$(document).on("keydown", function (e) {
    e = window.event || e;  // for browser compatibility
    if ((e.keyCode == 27) || (e.keyCode == 116) ||
        (e.ctrlKey && window.event.keyCode == 82)) {
        e.keyCode = 0;
        return false;
    }
    else {
        // refresh
    }
});

/*window.addEventListener('beforeunload', function(event) {
    console.log('Handle beforeunload !');
    // Cancel the event
    event.preventDefault();
    // Chrome requires returnValue to be set
    event.returnValue = '';
});*/
window.onbeforeunload = function (e) {
    console.log('Handle beforeunload !');
    e = window.event || e;  // for browser compatibility
    // IE8 & Firefox 4
    if (e) {
        e.returnValue = '';
    }
    // Chrome, Safari, Firefox 4+, Opera 12+ , IE 9+
    return false;
};

window.alert = function(msg, callback) {
    let lumensAlertDialog = document.getElementById("lumensAlertDialog");
    if (lumensAlertDialog && gIsAlertVisible) {
        let alertMessage = document.getElementById("alertMessage");
        if (alertMessage) {
            alertMessage.innerHTML = msg;
        }
        return;
    }
    gIsAlertVisible = true;
    var div = document.createElement("div");
    div.innerHTML = "<div id=\"lumensAlertDialog\" style=\"display: none; z-index: 9000;\">"
        + " <div class=\"lumensMask\" style=\"z-index: 8998;\"></div>"
        + " <div class=\"lumensAlert\" style=\"z-index: 8999;\">"
        + " <div class=\"lumensAlertHead\">"
        + " <strong class=\"lumensAlertTitle\" id=\"alertTitle\"></strong>"
        + " </div>"
        + " <div class=\"lumensAlertBody\" id=\"alertMessage\">Alert Message</div>"
        + " <div class=\"lumensAlertFoot\">"
        + " <strong class=\"lumensAlertBtn lumensAlertBtnPrimary\" id=\"alertOK\">Done</strong>"
        + " </div>"
        + " </div>"
        + "</div>";
    document.body.appendChild(div);
    lumensAlertDialog = document.getElementById("lumensAlertDialog");
    lumensAlertDialog.style.display = 'block';
    var alertTitle = document.getElementById("alertTitle");
    alertTitle.innerHTML = "CamConnect Processor";
    alertTitle.style.display = 'block';
    var alertMessage = document.getElementById("alertMessage");
    alertMessage.innerHTML = msg;
    var alertOK = document.getElementById("alertOK");
    alertOK.innerHTML = window.LanguageManager.getTranslatedText("OK");

    const closeAlert = () => {
        lumensAlertDialog.style.display = 'none';
        lumensAlertDialog.remove();
        gIsAlertVisible = false;
        if (!isAuthenticated && document.getElementById('btnLogin')) {
            document.getElementById('btnLogin').disabled = false;
        }
        if (needChange && isAuthenticated) {
            needChange = false;
            gHadLogin = true;
            setLoginStatus(true);
            hideLoginPanel();
            clearCurrentPassword();
        }

        if(gSetPasswordSuccess)
        {
            gSetPasswordSuccess = false;
            createLoginPanel();
        }

        document.removeEventListener('keydown', handleKeydown);
    };

    alertOK.onclick = closeAlert;

    const handleKeydown = (e) => {
        if (e.key === 'Enter') {
            closeAlert();
        }
    };

    document.addEventListener('keydown', handleKeydown);

};

function createCameraPTZWindows() {
    var ZoneMapCameraSettingWindow = document.getElementById('cameralist_CameraPTZWindows');
    ZoneMapCameraSettingWindow.innerHTML = '';
     console.log('1 test!');
        var modalPTZ = document.createElement('div');
        modalPTZ.className = 'CameraSettingtitlemodalPTZ';
        modalPTZ.style.backgroundColor = 'black';
        modalPTZ.style.display = 'block';
        modalPTZ.id = 'cameralist_PTZModal';
            var modalDialog = document.createElement('div');
                var modalContent = document.createElement('div');
                    var titleRow = document.createElement('tr');
                        var titleBarRowCell = document.createElement('td');
                        titleBarRowCell.className = 'CameraSettingtitleBarRow';

                            var logoCell = document.createElement('td');
                            logoCell.className = 'title-bar-cell logo-cell';
                                var logoImage = document.createElement('img');
                                logoImage.id = 'logo_image';
                                logoImage.className = 'mic-popup-Window-logo-Image';
                                logoImage.src = '../imagesaibox/CamConnect.png';
                            logoCell.appendChild(logoImage);

                            var titleCell = document.createElement('td');
                            titleCell.className = 'title-bar-cell title-cell';
                            titleCell.style.margin = '10px';
                                var titleLabel = document.createElement('label');
                                titleLabel.className = 'Font_Arial_18_bold mic-xy-title';
                                titleLabel.textContent = 'CamConnect Processor';
                                
                            titleCell.appendChild(titleLabel);

                            var closeButtonCell = document.createElement('td');
                            closeButtonCell.className = 'title-bar-cell close-button-cell';
                                var closeButton = document.createElement('button');
                                closeButton.id = 'cameralist_close_CameraSetting_Window';
                                closeButton.className = 'close-popup-btn';
                                closeButton.setAttribute("onclick", "closeCameraPTZWindow(this)");
                            closeButtonCell.appendChild(closeButton);

                        titleBarRowCell.appendChild(logoCell);
                        titleBarRowCell.appendChild(titleCell);
                        titleBarRowCell.appendChild(closeButtonCell);
                        
                    titleRow.appendChild(titleBarRowCell);

                    var modalPTZBody = document.createElement('div');
                    modalPTZBody.className = 'modalPTZ-body';
                        
                        var imgContents = document.createElement('div');
                        imgContents.id = 'cameralist_imgcontents';
                        imgContents.style.position = 'relative';
                            
                            var imgLoader = document.createElement('img');
                            imgLoader.id = 'cameralist_loader';
                            imgLoader.className = 'CameraSettingimgloader';
    
                        imgContents.appendChild(imgLoader);
                    modalPTZBody.appendChild(imgContents);

                    var directionMirrorDiv = document.createElement('div');
                    directionMirrorDiv.className = 'CameraSettingDirectionMirrorDiv';
                        // var labelLR = document.createElement('label');
                        // labelLR.className = 'Font_Arial_14_bold CameraSetting_LR_Direction_label';
                        // labelLR.textContent = 'L/R Direction';

                        // var switchOnOff = document.createElement('label');
                        // switchOnOff.className = 'switch_onoff';
                        //     var inputLR = document.createElement('input');
                        //     inputLR.type = 'checkbox';
                        //     inputLR.id = 'cameralist_PTZLRDirection';
                        //     inputLR.name = 'LRDirection';
                        //     inputLR.setAttribute('onchange', 'cameralist_onchangePanFlip(this)');
                        //     var spanSlider = document.createElement('span');
                        //     spanSlider.className = 'slider_onoff';
                        // switchOnOff.appendChild(inputLR);
                        // switchOnOff.appendChild(spanSlider);

                        var labelMirrorFlip = document.createElement('label');
                        labelMirrorFlip.className = 'Font_Arial_14_bold CameraSetting_MirrorFlip_label';
                        labelMirrorFlip.textContent = window.LanguageManager.getTranslatedText("Mirror_Flip");

                        var selectMirrorFlip = document.createElement('select');
                        selectMirrorFlip.id = 'cameralist_PTZMirrorFlipType';
                        selectMirrorFlip.className = 'selectH24 selectW100';
                        selectMirrorFlip.setAttribute('onchange', 'PTZMirrorFlipTypeChange(this)'); 
                        [ window.LanguageManager.getTranslatedText("OFF"), 
                          window.LanguageManager.getTranslatedText("Mirror"), 
                          window.LanguageManager.getTranslatedText("Flip"), 
                          window.LanguageManager.getTranslatedText("Mirror_add_Flip")].forEach((value, index) => {
                            var option = document.createElement('option');
                            option.value = index;
                            option.textContent = value;
                            selectMirrorFlip.appendChild(option);
                        });

                    //directionMirrorDiv.appendChild(labelLR);
                    //directionMirrorDiv.appendChild(switchOnOff);
                    directionMirrorDiv.appendChild(labelMirrorFlip);
                    directionMirrorDiv.appendChild(selectMirrorFlip);

                    var divPanTiltZone = document.createElement('div');
                    divPanTiltZone.id = 'Div_PanTiltZone';
                    divPanTiltZone.className = 'PanTiltZoneDiv';
                    
                        var panTiltBtnGrid = document.createElement('ul');
                        panTiltBtnGrid.className = 'CameraSetting_PanTiltBtnGrid';
            
                        var buttons = [
                            { id: 'cameralist_ptUpLeftButton',     className: 'PT_UpLeft_Btn',      },
                            { id: 'cameralist_ptUpButton',         className: 'PT_Up_Btn PT_Up_img',},
                            { id: 'cameralist_ptUpRightButton',    className: 'PT_UpRight_Btn',     },
                            { id: 'cameralist_ptLeftButton',       className: 'PT_Left_Btn',        },
                            { id: 'cameralist_HomeButton',         className: 'PT_Home_Btn',        },
                            { id: 'cameralist_ptRightButton',      className: 'PT_Right_Btn',       },
                            { id: 'cameralist_ptDownLeftButton',   className: 'PT_DownLeft_Btn',    },
                            { id: 'cameralist_ptDownButton',       className: 'PT_Down_Btn',        },
                            { id: 'cameralist_ptDownRightButton',  className: 'PT_DownRight_Btn',   },
                        ];
                        
                        buttons.forEach(function(button) {
                            var li = document.createElement('li');
                            var btn = document.createElement('button');
                            btn.id = button.id;
                            btn.className = button.className;
                            //btn.setAttribute("onclick", "PanTiltElement(this)");
                            btn.addEventListener('mousedown', function() {                                
                                var dir = 'LeftDown';
                                if(btn.id == 'cameralist_ptUpLeftButton')
                                    dir = 'LeftUp';
                                else if(btn.id == 'cameralist_ptUpButton')
                                    dir = 'Up';
                                else if(btn.id == 'cameralist_ptUpRightButton')
                                    dir = 'RightUp';
                                else if(btn.id == 'cameralist_ptLeftButton')
                                    dir = 'Left';
                                else if(btn.id == 'cameralist_HomeButton')
                                    dir = 'home';
                                else if(btn.id == 'cameralist_ptRightButton')
                                    dir = 'Right';
                                else if(btn.id == 'cameralist_ptDownLeftButton')
                                    dir = 'LeftDown';
                                else if(btn.id == 'cameralist_ptDownButton')
                                    dir = 'Down';
                                else if(btn.id == 'cameralist_ptDownRightButton')
                                    dir = 'RightDown';
                                ptCmdRun = true;
                                setTimeout(function () {
                                    sendPanTiltCmd(dir);
                                }, 100);
                            });

                            if(btn.id != 'cameralist_HomeButton')
                            {
                                btn.addEventListener('mouseup', function() {                                
                                    stopPanTiltMoving();
                                });
                                btn.addEventListener('mouseleave', function() {                                
                                    stopPanTiltMoving();
                                });
                            }

                            li.appendChild(btn);
                            panTiltBtnGrid.appendChild(li);
                        });
                    
                    divPanTiltZone.appendChild(panTiltBtnGrid);
                    var divPresetZone = document.createElement('div');
                    divPresetZone.id = 'Div_presetZone';
                    divPresetZone.className = 'presetZoneDiv';
                        
                        var labelPreset = document.createElement('label');
                        labelPreset.className = 'CameraSetting_presetLabel Font_Arial_14_bold';
                        labelPreset.textContent = window.LanguageManager.getTranslatedText("Preset");
                        var inputPreset = document.createElement('input');
                        inputPreset.type = 'text';
                        inputPreset.id = 'cameralist_presetInput';
                        inputPreset.className = 'presetInput';
                        inputPreset.oninput = function() { this.value = this.value.replace(/[^\d]/g, ''); };
                        var ulPresetBtnGrid = document.createElement('ul');
                        ulPresetBtnGrid.className = 'CameraSetting_presetBtnGrid';

                        function storeButtonfunc() {
                                var presetValue = document.getElementById('cameralist_presetInput').value;
                                sendStorePresetCmd(presetValue);
                                document.getElementById('cameralist_presetInput').value = "";
                        }

                        function recallButtonfunc() {
                                var presetValue = document.getElementById('cameralist_presetInput').value;
                                sendRecallPresetCmd(presetValue);
                                document.getElementById('cameralist_presetInput').value = "";
                        }

                        var presetButtons = [
                            { id: 'cameralist_presetNum1Button',   class: 'presetBtn',      text: '1'  ,   action: function() { presetTextAction("1"); } },
                            { id: 'cameralist_presetNum2Button',   class: 'presetBtn',      text: '2'  ,   action: function() { presetTextAction("2"); } },
                            { id: 'cameralist_presetNum3Button',   class: 'presetBtn',      text: '3'  ,   action: function() { presetTextAction("3"); } },
                            { id: 'cameralist_presetNum4Button',   class: 'presetBtn',      text: '4'  ,   action: function() { presetTextAction("4"); } },
                            { id: 'cameralist_presetNum5Button',   class: 'presetBtn',      text: '5'  ,   action: function() { presetTextAction("5"); } },
                            { id: 'cameralist_presetNum6Button',   class: 'presetBtn',      text: '6'  ,   action: function() { presetTextAction("6"); } },
                            { id: 'cameralist_presetNum7Button',   class: 'presetBtn',      text: '7'  ,   action: function() { presetTextAction("7"); } },
                            { id: 'cameralist_presetNum8Button',   class: 'presetBtn',      text: '8'  ,   action: function() { presetTextAction("8"); } },
                            { id: 'cameralist_presetNum9Button',   class: 'presetBtn',      text: '9'  ,   action: function() { presetTextAction("9"); } },
                            { id: 'cameralist_presetStoreButton',  class: 'presetBtn',      text: window.LanguageManager.getTranslatedText("Store"), action: function() { storeButtonfunc();} },
                            { id: 'cameralist_presetNum0Button',   class: 'presetBtn',      text: '0'  ,   action: function() { presetTextAction("0"); } },
                            { id: 'cameralist_presetRecallButton', class: 'presetClearBtn', text: ''   ,   action: function() { recallButtonfunc(); } },
                        ];

                        presetButtons.forEach(function(button) {
                            var li = document.createElement('li');
                            var btn = document.createElement('button');
                            btn.id = button.id;
                            btn.className =  button.class;
                            if (button.text) {
                                var span = document.createElement('span');
                                span.className = 'presetBtnText';
                                span.textContent = button.text;
                                btn.appendChild(span);
                            }
                            if (button.action) {
                                btn.addEventListener('click', button.action);
                            }
                            li.appendChild(btn);
                            ulPresetBtnGrid.appendChild(li);
                        });
                        
                    divPresetZone.appendChild(labelPreset);
                    divPresetZone.appendChild(inputPreset);
                    divPresetZone.appendChild(ulPresetBtnGrid);

                    var divAFcousZone = document.createElement('div');
                    divAFcousZone.id = 'cameralist_Div_AFcousZone';
                    divAFcousZone.className = 'CameraSetting_AFcousZoneDiv';
                        var table = document.createElement('table');
                        table.style.borderCollapse = 'separate';
                        table.style.borderSpacing = '15px 15px';
                            var tr1 = document.createElement('tr');
                            tr1.className = 'align-Td';
                                var td1 = document.createElement('td');
                                    var label1 = document.createElement('label');
                                    label1.className = 'switch_afmf';
                                        var input = document.createElement('input');
                                        input.type = 'checkbox';
                                        input.id = 'cameralist_focusModeCheckboxInput';
                                        input.setAttribute('onchange', 'focusModeChange(this)');
                                        var span = document.createElement('span');
                                        span.className = 'slider_afmf';
                                    label1.appendChild(input);
                                    label1.appendChild(span);
                                td1.appendChild(label1);
                                var td2 = document.createElement('td');
                                    var buttonNear = document.createElement('button');
                                    buttonNear.id = 'cameralist_focusNearButton';
                                    buttonNear.className = 'FocusPlus_Btn';
                                    //buttonNear.setAttribute('onclick', 'ManualFocusControl()');
                                    buttonNear.addEventListener('mousedown', function() {                                
                                        focusCmdRun = true;
                                        setTimeout(function () {
                                            sendManualFocusCmd('Near');
                                        }, 100);
                                    });
        
                                    buttonNear.addEventListener('mouseup', function() {                                
                                        stopFocusMoving();
                                    });
                                    buttonNear.addEventListener('mouseleave', function() {                                
                                        stopFocusMoving();
                                    });

                                td2.appendChild(buttonNear);
                                var td3 = document.createElement('td');
                                    var buttonFar = document.createElement('button');
                                    buttonFar.id = 'cameralist_focusFarButton';
                                    buttonFar.className = 'FocusMinus_Btn';
                                    //buttonFar.setAttribute('onclick', 'ManualFocusControl()');
                                    buttonFar.addEventListener('mousedown', function() {                                
                                        focusCmdRun = true;
                                        setTimeout(function () {
                                            sendManualFocusCmd('Far');
                                        }, 100);
                                    });
        
                                    buttonFar.addEventListener('mouseup', function() {                                
                                        stopFocusMoving();
                                    });
                                    buttonFar.addEventListener('mouseleave', function() {                                
                                        stopFocusMoving();
                                    });
                                td3.appendChild(buttonFar);
                            tr1.appendChild(td1);
                            tr1.appendChild(td2);
                            tr1.appendChild(td3);
                            var tr2 = document.createElement('tr');
                            tr2.className = 'align-Td';
                            [window.LanguageManager.getTranslatedText("AF_MF"),window.LanguageManager.getTranslatedText("Label_FocusPlus"),window.LanguageManager.getTranslatedText("Label_FocusMinus")].forEach(function(labelText, index) {
                                var td = document.createElement('td');
                                    var label = document.createElement('label');
                                    label.className = 'AFMF_label Font_Arial_14_bold';
                                    label.textContent = labelText;
                                    if (index === 0) {
                                        label.id = 'Label_AFMF';
                                    } else if (index === 1) {
                                        label.id = 'Label_FocusPlus';
                                    } else {
                                        label.id = 'Label_FocusMinus';
                                    }
                                    td.appendChild(label);
                                tr2.appendChild(td);
                            });
                            var tr3 = document.createElement('tr');
                            tr3.className = 'align-Td';
                                var td4 = document.createElement('td');
                                var labelZoom = document.createElement('label');
                                labelZoom.className = 'AFMF_label Font_Arial_14_bold';
                                labelZoom.id = 'cameralist_Label_FocusMinus';
                                labelZoom.textContent = window.LanguageManager.getTranslatedText("Zoom");
                                td4.appendChild(labelZoom);
                                var td5 = document.createElement('td');
                                var zoomTeleButton = document.createElement('button');
                                zoomTeleButton.id = 'cameralist_zoomTeleButton';
                                zoomTeleButton.className = 'ZoomPlus_Btn';
                                //zoomTeleButton.setAttribute('onclick', 'ZoomBtnElements()');
                                zoomTeleButton.addEventListener('mousedown', function() {                                
                                    zoomCmdRun = true;
                                    setTimeout(function () {
                                        sendZoomCmd('In');
                                    }, 100);
                                });
    
                                zoomTeleButton.addEventListener('mouseup', function() {                                
                                    sendZoomStopCmd();
                                });
                                zoomTeleButton.addEventListener('mouseleave', function() {                                
                                    sendZoomStopCmd();
                                });
                                td5.appendChild(zoomTeleButton);
                                var td6 = document.createElement('td');
                                var zoomWideButton = document.createElement('button');
                                zoomWideButton.id = 'cameralist_zoomWideButton';
                                zoomWideButton.className = 'ZoomMinus_Btn';
                                //zoomWideButton.setAttribute('onclick', 'ZoomBtnElements()');
                                zoomWideButton.addEventListener('mousedown', function() {                                
                                    zoomCmdRun = true;
                                    setTimeout(function () {
                                        sendZoomCmd('Out');
                                    }, 100);
                                });
    
                                zoomWideButton.addEventListener('mouseup', function() {                                
                                    sendZoomStopCmd();
                                });
                                zoomWideButton.addEventListener('mouseleave', function() {                                
                                    sendZoomStopCmd();
                                });
                                td6.appendChild(zoomWideButton);
                            tr3.appendChild(td4);
                            tr3.appendChild(td5);
                            tr3.appendChild(td6);
                            
                        table.appendChild(tr1);
                        table.appendChild(tr2);
                        table.appendChild(tr3);
                    divAFcousZone.appendChild(table);
                    var modalFooter = document.createElement('div');
                    modalFooter.className = 'modal-footer';
                    modalFooter.style.backgroundColor = 'black';
                    modalFooter.style.marginTop = '8px';

            modalContent.appendChild(titleRow);
            modalContent.appendChild(modalPTZBody);
            modalContent.appendChild(directionMirrorDiv);
            modalContent.appendChild(divPanTiltZone);
            modalContent.appendChild(divPresetZone);
            modalContent.appendChild(divAFcousZone);
            modalContent.appendChild(modalFooter);
            

            modalDialog.appendChild(modalContent);
        modalPTZ.appendChild(modalDialog);
    ZoneMapCameraSettingWindow.appendChild(modalPTZ);
}

function closeCameraPTZWindow(){
    var cameraPTZWindow =  document.getElementById('cameralist_CameraPTZWindows');
    cameraPTZWindow.style.display = 'none';
    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }
    
    console.log("closeCameraPTZWindow TableRowIndex:",gCurrentOperationTableRowIndex-1);
    console.log("closeCameraPTZWindow IP:",cameraIP);

    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.IsPreview = false;
    sendMessageCameralist(jsonmsg.Command,jsonmsg);

    enabledLeftMenuOnPopWindowClose();
}

function cameralist_onchangePanFlip(element) {

    var cameraIP = document.getElementById("cameraIP_"+(gCurrentOperationTableRowIndex-1)).innerText;
    var isDante = false;
    if(document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText.indexOf("DanteCH") >= 0)
    {
        cameraIP = document.getElementById("cameraName_"+(gCurrentOperationTableRowIndex-1)).innerText;
        isDante = true;
    }
    
    console.log("cameralist_onchangePanFlip TableRowIndex:",gCurrentOperationTableRowIndex-1);
    console.log("cameralist_onchangePanFlip IP:",cameraIP);

    var jsonmsg = {};
    jsonmsg.Command = "SetPanFlip";
    jsonmsg.IPAddress = cameraIP; 
    
    if(element.checked){
        console.log('PanFlip is checked');
        jsonmsg.IsFlip = true;
    }
    else{
        console.log('PanFlip is not checked');
        jsonmsg.IsFlip = false;
    }
    sendMessageCameralist("SetPanFlip",jsonmsg);

}
